function res = chris_NaK()
%  CHRIS_NAK()
%   Characterizes IV curves for Chris'es data, based on raw current amplitudes stored in a certain Excel file. 
%   See and edit the function text if necessary (also read the "Data Flow" document).

% Oct 08 2013: Come back revision. Now supports Discobox data (through [fileNumber] switch).
% May 29 2014: Adjusted for new set of data.
% Jun 02 2014: Minor changes in figure design.
% Jan 16 2015: Minor update for looking at selected neurons.


fileName = 'C:\Users\Arseny\Documents\4_Cells Classification\2014 data\FinalData (20140415).xlsx'; 
sheetNames{1} = 'IVStepFinal'; 
list = [64006]                     % In case we need ONLY these cells, for debugging, testing or drawing purposes

doNa = 1;   % Which analyses to do
doKs = 1;
doKt = 1;

[dataN,dataT] = xlsread(fileName, sheetNames{1});   % Numbers and text
dataN = dataN(2:end,:);                             % 1st row is still titles
cellId = dataN(:,1)*1000 + dataN(:,4);              % Cell id
stage = dataN(:,3);
disco = dataN(:,4);                                 % Whether it was a discoboxed tadpole
dataN = dataN(:,7:end);                             % First 6 columns contain cell information and other crap that was just stored into separate variables

goodCells = ~isnan(sum(dataN,2));                   % Nan cells should be removed.
cellId = cellId(goodCells);
stage  = stage(goodCells);
disco  = disco(goodCells);
dataN  = dataN(goodCells,:);

maxX = 60;
dataNa = dataN(:,(1:10)+10);                        % Minima = Na
dataKs = dataN(:,(1:10)+20);                        % Average at the end = slow K
dataKt = dataN(:,(1:10)+30);                        % Max-average = fast K (aka "transient", thus Kt)
v = [-65	-55	-45	-35	-25	-15	-5	5	15	25];    % Voltages, mV, used by Chris in his experiments

if(exist('list','var'))
    if(~isempty(list))
        ind = find(ismember(cellId,list));
        cellId = cellId(ind);
        dataNa = dataNa(ind,:);
        dataKs = dataKs(ind,:);
        dataKt = dataKt(ind,:);
    end
end

[~,ind] = sort(v); % Sorting potentials
v = v(ind);
dataNa = -dataNa(:,ind); % Also making positive
dataKs = dataKs(:,ind);
dataKt = dataKt(:,ind);
vv = linspace(min(v),max(v),100);

[nCells,l] = size(dataNa);
plotN = floor(sqrt(nCells)/1.3); % Layout for the multiple currents plot
plotM = ceil(nCells/plotN);

plotN = 4; plotM = 6;                   % If instead of one giant figure you want to create several figures 4x6 figures
if(length(list)<2)
    plotN = 1; plotM = 1;
end

% figure;
% subplot(1,3,1); plot(v,dataNa); title('Na');
% subplot(1,3,2); plot(v,dataKs); title('Ks');
% subplot(1,3,3); plot(v,dataKt); title('Kt');

if(0)
    figure;
    subplot(2,3,1); plot(v,dataNa); title('Na');
    subplot(2,3,2); plot(v,dataKs); title('Ks');
    subplot(2,3,3); plot(v,dataKt); title('Kt');
    subplot(2,3,4); plot(v,bsxfun(@times,dataNa,1./max(abs(dataNa),[],2))); title('Na scaled');
    subplot(2,3,5); plot(v,bsxfun(@times,dataKs,1./max(abs(dataKs),[],2))); title('Ks scaled');
    subplot(2,3,6); plot(v,bsxfun(@times,dataKt,1./max(abs(dataKt),[],2))); title('Kt scaled');
end
    
% [~,ind] = sort(sum(dataKs,2)); % Sorting along total stable K current (why not?)
% dataNa = dataNa(ind,:);
% dataKs = dataKs(ind,:);
% dataKt = dataKt(ind,:);
% 
% figure;
% subplot(1,3,1); plot(v,bsxfun(@plus,dataNa,(1:n)'*10)); title('Na');
% subplot(1,3,2); plot(v,bsxfun(@plus,dataKs,(1:n)'*10)); title('Ks');
% subplot(1,3,3); plot(v,bsxfun(@plus,dataKt,(1:n)'*10)); title('Kt');


fprintf('\n');

if(doNa)
    [f,s] = myfittypes('sigmoidoid',maxX);
    fprintf('Na data\n');
    fprintf('      id\tXhalf\tAmp\n');
    figure('Color','w');
    for(iCell=1:nCells)
        try
            [c2,gof2] = fit(v',dataNa(iCell,:)',f,s);
        catch
            dispf('An error happened');
            dispf('data:')
            dispf(dataNa(iCell,:));
            error();                        % Let's generate some kind of an error anyway (I don't remember how to do it properly)
        end
        fmaxx = fminbnd(@(x)(-c2(x)),min(v),max(v));                % Using anonymous function to find curve maximum
        fmid  = fminbnd(@(x)(abs(c2(x)-c2(fmaxx)/2)),min(v),fmaxx); % Using anonymous function to find curve middle point

        subplot(plotN,plotM,mod(iCell-1,plotN*plotM)+1);            % Complex formula to make multi-plating possible
        hold on;
        plot(vv,c2(vv'),'r-');
        plot(v,dataNa(iCell,:),'b.');    
        plot(fmaxx,c2(fmaxx),'ko');
        plot(fmid,c2(fmid),'kx');
        set(gca,'FontSize',6,'XTick',[]);
        if(plotM>10); set(gca,'YTick',[]); end;
        title(cellId(iCell));
        hold off;
        drawnow;
        fprintf('%8d\t%5.1f\t%5.1f\n',[cellId(iCell) fmid c2(fmaxx)]);

        if(iCell<nCells)
            if(mod(iCell,plotN*plotM)==0);            % Time to get a new figure window
                figure('Color','w');
            end
        end
    end
    supertitle('Na data');
end


if(doKs)
    [f,s] = myfittypes('cutexp',maxX);
    fprintf('Ks data\n');
    fprintf('      id\tFirst\tAmp\n');
    figure('Color','w');
    for(iCell=1:nCells)
        [c2,gof2] = fit(v',dataKs(iCell,:)',f,s);

        subplot(plotN,plotM,mod(iCell-1,plotN*plotM)+1); 
        hold on;    
        plot(vv,c2(vv'),'r-');
        plot(v,dataKs(iCell,:),'b.');        
        set(gca,'FontSize',6,'XTick',[]);
        if(plotM>10); set(gca,'YTick',[]); end;
        title(cellId(iCell));
        hold off;
        drawnow;
        fprintf('%8d\t%5.1f\t%5.1f\n',[cellId(iCell) c2.a+log(c2.e)*c2.b max(dataKs(iCell,:))]);
        if(iCell<nCells)
            if(mod(iCell,plotN*plotM)==0);            % Time to get a new figure window
                figure('Color','w');
            end
        end
    end
    supertitle('Ks data');
end


if(doKt)
    [f,s] = myfittypes('sigmoidoid',maxX);
    fprintf('Kt data\n');
    fprintf('      id\tXhalf\tAmp\n');
    figure('Color','w');
    for(iCell=1:nCells)
        [c2,gof2] = fit(v',dataKt(iCell,:)',f,s);
        fmaxx = fminbnd(@(x)(-c2(x)),min(v),max(v)); % Using anonymous function to find curve maximum
        fmid  = fminbnd(@(x)(abs(c2(x)-c2(fmaxx)/2)),min(v),fmaxx); % Using anonymous function to find curve maximum

        subplot(plotN,plotM,mod(iCell-1,plotN*plotM)+1); 
        hold on;
        plot(vv,c2(vv'),'r-');
        plot(v,dataKt(iCell,:),'b.');    
        plot(fmaxx,c2(fmaxx),'ko');
        plot(fmid,c2(fmid),'kx');
        set(gca,'FontSize',6,'XTick',[]);
        if(plotM>10); set(gca,'YTick',[]); end;
        title(cellId(iCell));
        hold off;
        drawnow;
        fprintf('%8d\t%5.1f\t%5.1f\n',[cellId(iCell) fmid c2(fmaxx)]);
        if(iCell<nCells)
            if(mod(iCell,plotN*plotM)==0);            % Time to get a new figure window
                figure('Color','w');
            end
        end
    end
    supertitle('Kt data');
end

end

function [f,s] = myfittypes(kind,maxX)
switch(kind)
    case 'exp'
        f = fittype('exp((x-a)/b)*c+d','independent','x');
        s = fitoptions('Method','NonlinearLeastSquares',...
                       'Lower',     [-maxX   1   0   0],...
                       'Upper',     [maxX    maxX Inf Inf],...
                       'Startpoint',[0      10  1   1]);
    case 'cutexp'
        f = fittype('max(0,exp((x-a)/b)-e)*c+d','independent','x');
        s = fitoptions('Method','NonlinearLeastSquares',...
                       'Lower',     [-maxX   1      0   0   0],...
                       'Upper',     [maxX    maxX   Inf Inf 1],...
                       'Startpoint',[0       10     1   1   0.1]);
    case 'sigmoid'
        f = fittype('c/(1+exp(-(x-a)/b)+d)','independent','x');
        s = fitoptions('Method','NonlinearLeastSquares',...
                       'Lower',     [-maxX   1   0   0],...
                       'Upper',     [maxX    maxX Inf Inf],...
                       'Startpoint',[0      10  1   1]);
       case 'sigmoidoid'
        f = fittype('c*exp(x/b1)./(1+exp(-(a-x)/b2))','independent','x');
        s = fitoptions('Method','NonlinearLeastSquares',...
                       'Lower',     [-maxX   .1      .1        0   ],...
                       'Upper',     [0     maxX    maxX     Inf ],...
                       'Startpoint',[-1       10     10       1   ]);
   case 'xexp'
        f = fittype('(x-a)*exp(-(x-b)/c)*d+e','independent','x');
        s = fitoptions('Method','NonlinearLeastSquares',...
                       'Lower',     [-maxX   -maxX   1   0   0],...
                       'Upper',     [maxX    maxX    maxX Inf Inf],...
                       'Startpoint',[0      0      100  1   1]);
end
end